
* This codes prepares the dataset that goes as input sheets into "Figure 12 - Decomposition Input.xlsx"
* Please note, however, that the replication code does not include a variable that is proprietary: backlogs of work (our license for the data does not allow for sharing with non-subscribers).

***************************************************************
* Read in data
***************************************************************


set more off
clear
* Put name of your main directory path here:
local main = "___"
use `main'\data_monthly.dta, clear
cd `main'\results\charts

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

* Sample dummies
forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1960m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=tm(2022m9))

g sample13 = 0
replace sample13 = 1 if (sample1==1 | sample3==1)
g sample34 = 0
replace sample34 = 1 if (sample3==1 | sample4==1)


* Relative price fluctuations (supply shocks)
g his			= CPI - Median
* 12-month average
gen his_12ma	= (1/12)*(his + his[_n-1] + his[_n-2] + his[_n-3] + his[_n-4] + his[_n-5] + his[_n-6] + his[_n-7] + his[_n-8] + his[_n-9] + his[_n-10] + his[_n-11])

* Overall sample
keep if (t>=tm(1960m1)) & (t<=tm(2022m9))

* Define PC variables:
cap drop y* x*
g y		= Median-pe

* Loop over measures of slack
	* Define measure of slack ("x")
	cap drop x*
	g x		= vu_12ma
	g x2	= x^2
	g x3	= x^3
	gen z	= his_12ma
	gen z2	=z^2
	gen z3	=z^3

	
	label variable x "Slack"
	label variable x2 "Slack-squared"
	label variable x3 "Slack-cubed"

	label variable z "Headline-inflation shock"
	label variable z2 "Headline-inflation shock-squared"	
	label variable z3 "Headline-inflation shock-cubed"
	
	* Decomposition of core
	
	local ctitle = "1985-2019"
	reg y x x2 x3 z z2 z3 if sample34==1, r
	predict yhat
	
	g yhat_cons=_b[_cons]		
	g yhat_slack=_b[x]*x+_b[x2]*x2+_b[x3]*x3
	g yhat_his=_b[z]*z+_b[z2]*z2+_b[z3]*z3
	gen yhat_test=yhat_cons+yhat_slack+yhat_his
	sum yhat yhat_test
	predict resid_median, residuals

	sum t if e(sample)
	
	foreach var of varlist pe his yhat yhat_slack yhat_his yhat_cons resid_median {
		gen `var'_12=(1/12)*(`var' + `var'[_n-1] + `var'[_n-2] + `var'[_n-3] + `var'[_n-4] + `var'[_n-5] + `var'[_n-6] + `var'[_n-7] + `var'[_n-8] /// 
		+ `var'[_n-9] + `var'[_n-10] + `var'[_n-11])
	}
	
	local t0 = r(min)
	local t1 = r(max)

	save temp, replace
	
	* Outsheet Decomposition of core 2020m12 and 2022m9
	
	keep if t==tm(2020m12) | t==tm(2022m9)
	keep t CPI_12 Median_12 pe_12 his_12 yhat_12 yhat_slack_12 yhat_his_12 yhat_cons_12 resid_median_12 
	order t CPI_12 Median_12 pe_12 his_12 yhat_12 yhat_slack_12 yhat_his_12 yhat_cons_12 resid_median_12 
	outsheet using decomp_bars1and2.xls, replace
	
	* Decomposition of HIS
	
use temp, replace
	
foreach var in energy allcars {
gen `var'_12ma	= (1/12)*(`var' + `var'[_n-1] + `var'[_n-2] + `var'[_n-3] + `var'[_n-4] + `var'[_n-5] + `var'[_n-6] + `var'[_n-7] + `var'[_n-8] + `var'[_n-9] + `var'[_n-10] + `var'[_n-11])
}

* Redefine energy price inflation and food price inflation in relative terms (relative to median).
replace energy	= energy - Median
replace food	= food - Median
replace allcars	= allcars - Median

* Outsheet Decomposition of core. 12 mo. given proprietary data. these will be hard pasted in the excel file
use temp, replace
keep if t>=tm(2019m11)
keep t Median pe his yhat yhat_slack yhat_his yhat_cons resid_median z 
order t	Median pe his yhat yhat_slack yhat_his yhat_cons resid_median z
outsheet using 12mo-decomp_bars1and2_m.xls, replace

cd `main'